/****************************************************************************
**
** Copyright (C) 2017 Witekio.
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCoap module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QCOAPRESOURCEDISCOVERYREPLY_H
#define QCOAPRESOURCEDISCOVERYREPLY_H

#include <QtCoap/qcoapreply.h>
#include <QtCoap/qcoapresource.h>
#include <QtCore/qlist.h>

QT_BEGIN_NAMESPACE

class QCoapResourceDiscoveryReplyPrivate;
class Q_COAP_EXPORT QCoapResourceDiscoveryReply : public QCoapReply
{
    Q_OBJECT

public:
    QVector<QCoapResource> resources() const;

Q_SIGNALS:
    void discovered(QCoapResourceDiscoveryReply *reply, QVector<QCoapResource> resources);

private:
    explicit QCoapResourceDiscoveryReply(const QCoapRequest &request, QObject *parent = nullptr);
    friend class QCoapClientPrivate;

    Q_DECLARE_PRIVATE(QCoapResourceDiscoveryReply)
};

QT_END_NAMESPACE

#endif // QCOAPRESOURCEDISCOVERYREPLY_H
